//
//  GSCallbackHandler.h
//  GlyphsCore
//
//  Created by Georg Seifert on 08/10/2016.
//  Copyright © 2016 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

extern NSString *GSDrawForegroundCallbackName;
extern NSString *GSDrawBackgroundCallbackName;
extern NSString *GSDrawInactiveCallbackName;
extern NSString *GSDrawFontViewCallbackName;
extern NSString *GSDrawPreviewCallbackName;

extern NSString *GSFilterFilterName;
extern NSString *GSPreFilterFilterName;
extern NSString *GSPreInterpolationFilterName;

extern NSString *GSFilterCallbackName;
extern NSString *GSPreFilterCallbackName;
extern NSString *GSPrepareLayerCallbackName;
extern NSString *GSFontDidOpenCallbackName;
extern NSString *GSFontDidScaleCallbackName;
extern NSString *GSInspectorViewControllersCallbackName;
extern NSString *GSPanelInspectorsViewControllersCallbackName;
extern NSString *GSContextMenuCallbackName;
extern NSString *GSSelectionChangeCallbackName;
extern NSString *GSFilterFlatKerning;
extern NSString *GSHandleCustomFiles;

@protocol GlyphsReporter;
@protocol GSFontCheckerProtocol;
@protocol GSShortcutCommandProtocol;
@protocol GlyphsCallback;
@class MGOrderedDictionary;
@class GSFont;
@class GSLayer;


@protocol GSFilterFlatKerningProtocol <NSObject>

// return the new kerning list or nil if there was a problem (set a meaningful error)
- (NSArray *)filterFlatKerning:(NSArray *)flatKerning font:(GSFont *)font error:(out NSError **)error;

@end

NSSet *_Nullable getIncludeExcludeGlyphListFilter(NSArray *arguments, BOOL *include, GSFont *font, NSError **error);

@interface GSCallbackHandler : NSObject

/// Maps reporter class names to reporter instances.
@property (class, nonatomic, strong) MGOrderedDictionary *reporterInstances;

- (instancetype)init __attribute__((unavailable("use class methods")));

/// all currently active reporter instances
+ (NSArray<NSObject<GlyphsReporter> *> *)activeReporters;

/// disables all active reporters
+ (void)resetActiveReporters;

/// activates the reporter
+ (void)activateReporter:(NSObject<GlyphsReporter> *)reporter;

/// deactivates the reporter
+ (void)deactivateReporter:(NSObject<GlyphsReporter> *)reporter;

/// deactivates the reporters
+ (void)deactivateReporters:(NSArray<NSObject<GlyphsReporter> *> *)reporters;

/// all active callbacks
+ (NSDictionary <NSString *, NSArray *> *)activeCallbacks;

/// the callbacks for a certain callbackType
+ (NSArray *)callbacksForType:(NSString *)callbackType;

+ (void)addCallback:(id)target forOperation:(NSString *)operation;

+ (void)removeCallback:(id)target forOperation:(NSString *)operation;

#ifndef LIBCORE
+ (void)registerFontChecker:(NSObject<GSFontCheckerProtocol> *)checker;

+ (NSArray *)fontCheckers;

#pragma mark Command Shortcuts

+ (NSArray *)commandShortcuts;

+ (void)registerShortcutCommand:(NSString *)title group:(NSString *)group identifier:(NSString *)identifier action:(SEL)action target:(NSObject<GSShortcutCommandProtocol> *)target character:(nullable NSString *)character modifierFlags:(NSEventModifierFlags)modifierFlags;

+ (void)keyDown:(NSEvent *)theEvent;
#endif

+ (BOOL)applyFilter:(NSArray *)customParameters withKey:(NSString *)filterKey error:(NSError **)error font:(GSFont *)font match:(nullable BOOL (^)(NSSet *glyphNames, BOOL include))match callback:(BOOL (^)(id filterInstance, NSArray *arguments))callback;

+ (BOOL)applyLayerCallbacks:(NSArray *)layerCallback toLayer:(GSLayer *)layer error:(out NSError **)error;

+ (void)respondToReporterCrash:(NSObject<GlyphsReporter> *)reporter exception:(NSException *)exception;

+ (void)respondToException:(NSException *)exception;

/// add class of view controller that handles UI for parameterName
+ (void)addCustomParameterViewClass:(Class)parameterClass forParameter:(NSString *)parameterName;

/// add class of window controller that handles UI for parameterName
+ (void)addCustomParameterSheetController:(Class)propertyDialogClass forParameter:(NSString *)parameterName;

#ifndef LIBCORE
+ (void)addFeatureCodeGenerator:(Class)featureCodeGenerator;

+ (NSArray *)featureCodeGenerators;
#endif

@end

NS_ASSUME_NONNULL_END
